// Ver.1.1.6 : 2023.05.31

// Game Control Plus (1.2.2) Peter Lagerをインストール（IDE上で）
import net.java.games.input.*;
import org.gamecontrolplus.*;
import org.gamecontrolplus.gui.*;
// シリアル通信用
import processing.serial.*;

ControlIO control;
ControlDevice device;
ControlButton button_0_X;
ControlButton button_1_Y;
ControlButton button_2_A;
ControlButton button_3_B;
ControlButton button_4_LB;
ControlButton button_5_RB;
ControlButton button_6_LT;
ControlButton button_7_RT;
ControlHat hat_13;

// Debugフラグ：設定の変更はsetup()内で行う
boolean debug                = true;   // 一般的なデバッグ用途（情報表示など）
boolean debug_noserial       = false;  // シリアル通信なしのオフラインデバッグ時にtrueに設定する
boolean debug_preventdumping = true;   // 直前と同じコマンドは送信しない．それにより異常が発生していると予想される場合は試しに false に変更する
boolean debug_nogamepad      = false;  // ゲームパッドが接続されていない環境ではtrueに自動設定される（手動での変更は不要）

// ＰＣとの通信路：有線（USB）の時はfalse，無線（XBee）の時はtrue，Processing側でも有線と無線を切り替える必要がある
final boolean Wireless = false;
Serial        myPort;
// シリアルポート（USB）の設定
final String  COMport  = "COM5";
final int     BPS      = 250000;

char    command_flag;            // ロボットに送信するコマンド
boolean advance_mode = false;    // false: 簡易操作モード, true: 高度操作モード 
// デバイス名（あなたの環境に合わせて変更要）
// Gcp_ShowDeviceで調べる
// https://garchiving.com/how-to-gamepad-in-processing/
// http://mslabo.sakura.ne.jp/WordPress/make/processing%E3%80%80%E9%80%86%E5%BC%95%E3%81%8D%E3%83%AA%E3%83%95%E3%82%A1%E3%83%AC%E3%83%B3%E3%82%B9/%E3%82%B2%E3%83%BC%E3%83%A0%E3%83%91%E3%83%83%E3%83%89%E3%82%92%E4%BD%BF%E3%81%86%E3%81%AB%E3%81%AF/
final String DEVNAME = "JC-U3613M - DirectXInput Mode";
 
void setup(){
// Debugフラグ
//   debug                = false;
   debug_noserial       = true;
//   debug_preventdumping = false;
  
  //シリアルポート設定
  if (! debug_noserial) myPort = new Serial(this, COMport, BPS);
  
  windowResize(WIN_WIDTH, WIN_HEIGHT);
  textAlign(LEFT,TOP);
  textSize(16);
  background(240, 240, 240);  // 背景色の指定
  
  // ゲームパッド関係
  control = ControlIO.getInstance(this); // インスタンス作成
  try {
    device  = control.getDevice( DEVNAME ); // デバイス取得
  } catch ( RuntimeException e) {
    debug_nogamepad = true;
  }
  if (! debug_nogamepad) {
    device.open(); // OPEN
    // ボタンを取得用インスタンスへのポインター
    button_0_X  = device.getButton( 0 );
    button_1_Y  = device.getButton( 1 );
    button_2_A  = device.getButton( 2 );
    button_3_B  = device.getButton( 3 );
    button_4_LB = device.getButton( 4 );  // 左（上側）ボタン：ショルダー
    button_5_RB = device.getButton( 5 );  // 右（上側）ボタン：ショルダー
    button_6_LT = device.getButton( 6 );  // 左（下側）ボタン：トリガー
    button_7_RT = device.getButton( 7 );  // 右（下側）ボタン：トリガー
    //ハットを取得用インスタンスへのポインター
    hat_13      = device.getHat( 13 );
  }
  // 日本語フォントを使用する
  PFont font = createFont(JapaneseFont, 50);
  textFont(font);
  
  // 簡易自動コマンドの初期化
  mc.resetAutoCommand();
}
 
void draw(){ // GUI追加予定。loop処理を一度終えるごとに、一つの変数をシリアルポートに送信する。
  //ボタンの種類ごとの処理設定
  //複数ボタン同時押しの場合（前進と関節回転）
  //final int start = millis();// 1/2追加。loop一周にかかる時間の確認

  background(240, 240, 240);  // 背景色の指定
  // ゲームパッド＆キーボード操作のチェック
  mc.check();        // 手動操作コマンドのチェック
  rc.robotController(); // ロボットへの動作指示
  rs.draw_GUI();        // GUIへの反映
}

ShortMessage SM = new ShortMessage();
final String JapaneseFont     = "Meiryo";
final int    Delay_message    = 2000;          // ショートメッセージの表示時間（ミリ秒）

// ウインドウとコンソールエリアに短いメッセージを一時的に表示するためのクラス
class ShortMessage {
private  int     start;
private  String  message;
private  boolean autoclear;
boolean busy;  // コメント表示中（マウスポインタのリアルタイム表示など，緊急性の低いコメントを抑制するために用いる）
  ShortMessage() {
    start     = millis();
    message   = "";
    autoclear = true;
  }
  void clear() {
    message = "";
  }
  void set_message(String str) {
    set_message(str, false, false);
  }
  void set_message_realtime(String str) {
    set_message(str, true, true);
  }
  // noconsole==trueで，Processing統合開発環境のコンソール領域への出力を抑制
  void set_message(String str, boolean noconsole, boolean realtime) {
    message = str;
    if (! noconsole) println(str);
    start   = millis();
    if (realtime != true) busy = true;
  }
  // draw()から呼ばれる
  void display_short_message(int x, int y) {
    if (millis() - start >= Delay_message) busy = false;
    if (autoclear) {
      if (! busy) return;  // 自動消去時は一定時間が経過したら表示しない
    }
//  menuScreen.fill_color(menuScreen.thema.shortmsg);
    fill(0, 0, 0);
    textAlign(LEFT, BASELINE);
    textSize(16);
    text(message, x, y);
  }
  // メッセージ自動消去を有効にする際には enable = trueとする
  void set_autoclear(boolean enable) {
    autoclear = enable;
  }
}
